program ParamBinding;

{$APPTYPE CONSOLE}

{%DelphiDotNetAssemblyCompiler '$(CommonProgramFiles)\borland shared\bds\shared assemblies\3.0\Borland.Data.Common.dll'}
{%DelphiDotNetAssemblyCompiler '$(CommonProgramFiles)\borland shared\bds\shared assemblies\3.0\Borland.Data.Provider.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Data.dll'}

uses
  SysUtils,
  Borland.Data.Provider,
  Borland.Data.Common,
  System.Data,
  System.IO;

  {
	   This simple demo shows how to use a BdpConnection, BdpCommand and BdpTransaction
	   to perform parameter binding.

	   Note that the connection string may need to change depending on the type of database
	   configuration on your local system. The demo uses the default employee.gdb database
	   that is installed in the default location of the Interbase 7.5 Server.
	}

var
  s_conn, s_tablename, s_create, s_insert, s_datafile, s_dataline: string;
  tokens : array of string;
	bdp_conn : BdpConnection;
  bdp_insertComm : BdpCommand;
  fs_datafile : FileStream;
  sr_filereader : StreamReader;
  bdp_trans : BdpTransaction;
  i : Integer;
  delim : array of char;

function ExecuteCommand( conn : BdpConnection; comm_text : string ): boolean;
var command : BdpCommand;
		bdp_trans : BdpTransaction;
begin
  result := true;

  try
    begin
      if conn.State <> ConnectionState.Open then
        conn.Open();

      bdp_trans := conn.BeginTransaction();
      command := BdpCommand.Create( comm_text, conn );
      command.ExecuteNonQuery();
      bdp_trans.Commit();

      conn.Close();
    end;
  except
    on e : Exception do
    begin
      console.WriteLine(e.Message);
      bdp_trans.Commit();
      result := false;
    end;
  end;
end;

begin
  // Create BdpConnection
  s_conn := 'assembly=Borland.Data.Interbase,Version=2.5.0.0,Culture=neutral,PublicKeyToken=91d62ebb5b0d1b1b;vendorclient=gds32.dll;database=c:\\Program Files\\Common Files\\Borland Shared\\data\\employee.gdb;' +
    'provider=Interbase;username=sysdba;password=masterkey';
  bdp_conn := BdpConnection.Create( s_conn );

  // Create Table
  s_tablename := 'EMPLOYEE_INFO';
  s_create := 'create table ' + s_tablename + '(EMP_NO SMALLINT, FIRST_NAME VARCHAR(15), LAST_NAME VARCHAR(20), PHONE_EXT VARCHAR(4), HIRE_DATE TIMESTAMP, DEPT_NO CHAR(3), JOB_CODE VARCHAR(5), JOB_GRADE SMALLINT, JOB_COUNTRY VARCHAR(15), SALARY DOUBLE PRECISION )';

  // Destroy Table if it already exists
  ExecuteCommand( bdp_conn, 'Drop table ' + s_tablename );

  if ExecuteCommand( bdp_conn, s_create ) = false then
  begin
      Console.WriteLine('Error creating table...\n Terminating Program.');
      Exit;
  end;

  // Create Insert Command with parameterized sql
  s_insert := 'INSERT INTO  ' + s_tablename + '(EMP_NO, FIRST_NAME, LAST_NAME, PHONE_EXT, HIRE_DATE, DEPT_NO, JOB_CODE, JOB_GRADE, JOB_COUNTRY, SALARY ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
  bdp_insertComm := BdpCommand.Create( s_insert, bdp_conn );
  bdp_insertComm.Parameters.Add('EMP_NO', DbType.Int16);
  bdp_insertComm.Parameters.Add('FIRST_NAME', DbType.String);
  bdp_insertComm.Parameters.Add('LAST_NAME', DbType.String);
  bdp_insertComm.Parameters.Add('PHONE_EXT', DbType.String);
  bdp_insertComm.Parameters.Add('HIRE_DATE', DbType.DateTime);
  bdp_insertComm.Parameters.Add('DEPT_NO', DbType.String);
  bdp_insertComm.Parameters.Add('JOB_CODE', DbType.String);
  bdp_insertComm.Parameters.Add('JOB_GRADE', DbType.Int16);
  bdp_insertComm.Parameters.Add('JOB_COUNTRY', DbType.String);
  bdp_insertComm.Parameters.Add('SALARY', DbType.Double);

  s_datafile := 'info.txt';
  fs_datafile := FileStream.Create(s_datafile, FileMode.Open, FileAccess.Read);
  sr_filereader := StreamReader.Create( fs_datafile );

  bdp_trans := nil;

  try
    begin
      bdp_conn.Open();

      bdp_insertComm.Prepare();
      bdp_trans := bdp_conn.BeginTransaction();

      SetLength( delim, 1 );
      delim[0] := ',';
      s_dataline := sr_filereader.ReadLine();
      while s_dataline <> nil do
      begin

        SetLength( tokens, bdp_insertComm.ParameterCount );
        tokens := s_dataline.Split(delim);

        for i := 0 to bdp_insertComm.ParameterCount - 1 do
        begin
          bdp_insertComm.Parameters[i].Value := tokens[i];
          Console.WriteLine('Parameter '+ IntToStr(i) + ' read from data token:'+tokens[i]);
        end;
        Console.WriteLine('Executing command '+bdp_insertComm.CommandText);
        bdp_insertComm.ExecuteNonQuery();

        s_dataline := sr_filereader.ReadLine();
      end;

      bdp_trans.Commit();

    end
  except
    on e : Exception do
    begin
      Console.Write('An Exception has occured: ' + e.Message);
      if bdp_trans <> nil then
        bdp_trans.Rollback();
    end;
  end;

  // close file and reader streams
  sr_filereader.Close();
  fs_datafile.Close();

  // close command and connection
  bdp_insertComm.Close();
  bdp_conn.Close();
end.


